#ifndef MY_MAP_REACTORS_H
#define MY_MAP_REACTORS_H

#include "MapReactors.h"
#include "DockPane.h"

class AcMyDrawingSetReactor : public AcMapDrawingSetReactor
{
public:
						AcMyDrawingSetReactor() ;

	virtual				~AcMyDrawingSetReactor() ;

    // The notification that the drawing is attached to the Drawing Set
    virtual void        DrawingAttached     (const AcMapAttachedDrawing *) ;
    
    // The notification that the drawing is detached from the Drawing Set
    virtual void        DrawingDetached    (unsigned long Id, const char *pcName, int level) ;
    
    // The notification that the  drawing is activated
    virtual void        DrawingActivated    (const AcMapAttachedDrawing *) ;
    
    // The notification that the drawing is deactivated
    virtual void        DrawingDeactivated  (const AcMapAttachedDrawing *) ;

    // The notification that the drawing settings are modified
    virtual void        DrawingSettingsModified 
											(const AcMapAttachedDrawing *) ;
	
	// Set a pointer to the Dialog so we can deal with the information
	void				SetDlg(CDockPane *pDlg) { m_pDlg = pDlg; };

	CDockPane *m_pDlg;

} ;

class AcMyQueryLibraryReactor : public AcMapQueryLibraryReactor
{
public:
						AcMyQueryLibraryReactor() ;

	virtual				~AcMyQueryLibraryReactor() ;

    // The notification that a query category is added.
    virtual void        QueryCategoryAdded	(const AcMapQueryCategory *pObj) ;
    
    // The notification that a query category is deleted.
    virtual void        QueryCategoryDeleted(unsigned long Id, 
											 const char *pcName) ;
    
    // The notification that a query category is renamed.
    virtual void        QueryCategoryRenamed(const AcMapQueryCategory *pObj) ;
    
    // The notification that a query is added.
    virtual void        QueryAdded		    (const AcMapQueryAttribute *pObj) ;
                                             
    // The notification that a query is deleted.
    virtual void        QueryDeleted	    (unsigned long QueryId,
											 const char *pcName) ;

    virtual void        QueryRenamed		(const AcMapQueryAttribute *pObj) ;

    virtual void        QueryModified		(const AcMapQueryAttribute *pObj) ;

	// Set a pointer to the Dialog so we can deal with the information
	void				SetDlg(CDockPane *pDlg) { m_pDlg = pDlg; };

	CDockPane *m_pDlg;
};

#endif